!function(){var t=X3D.define;X3D.require;t("standard/Math/Geometry/Spheroid3",[],function(){"use strict";function t(t,e){switch(arguments.length){case 0:this.semiMajorAxis=0,this.semiMinorAxis=0;break;case 2:this.semiMajorAxis=t,this.semiMinorAxis=e;break;case 3:var i=arguments[1];this.semiMajorAxis=t,this.semiMinorAxis=t*(1-1/i)}}return t.prototype={constructor:t,getSemiMajorAxis:function(){return this.semiMajorAxis},getSemiMinorAxis:function(){return this.semiMinorAxis},toString:function(){return this.semiMajorAxis+" "+this.semiMinorAxis}},t}),t("standard/Geospatial/ReferenceEllipsoids",["standard/Math/Geometry/Spheroid3"],function(t){"use strict";return{AA:new t(6377563.396,299.3249646,!0),AM:new t(6377340.189,299.3249646,!0),AN:new t(6378160,298.25,!0),BN:new t(6377483.865,299.1528128,!0),BR:new t(6377397.155,299.1528128,!0),CC:new t(6378206.4,294.9786982,!0),CD:new t(6378249.145,293.465,!0),EA:new t(6377276.345,300.8017,!0),EB:new t(6377298.556,300.8017,!0),EC:new t(6377301.243,300.8017,!0),ED:new t(6377295.664,300.8017,!0),EE:new t(6377304.063,300.8017,!0),EF:new t(6377309.613,300.8017,!0),FA:new t(6378155,298.3,!0),HE:new t(6378200,298.3,!0),HO:new t(6378270,297,!0),ID:new t(6378160,298.247,!0),IN:new t(6378388,297,!0),KA:new t(6378245,298.3,!0),RF:new t(6378137,298.257222101,!0),SA:new t(6378160,298.25,!0),WD:new t(6378135,298.26,!0),WE:new t(6378137,298.257223563,!0),SUN:new t(696342e3,1/9e-6,!0),MERCURY:new t(2439700,2439700),VENUS:new t(6051800,6051800),MOON:new t(1738140,1735970),MARS:new t(3395428,3377678),JUPITER:new t(71492e3,66854e3),SATURN:new t(60268e3,54364e3),URANUS:new t(2555e3,24973e3),NEPTUNE:new t(24764e3,24341e3),PLUTO:new t(1153e3,1153e3)}}),t("standard/Geospatial/Geodetic",["standard/Math/Numbers/Vector3","standard/Math/Algorithm"],function(t,e){"use strict";function i(t,e,i){this.longitudeFirst=!e,this.degrees=!i,this.a=t.getSemiMajorAxis(),this.c=t.getSemiMinorAxis(),this.c2a2=Math.pow(t.getSemiMinorAxis()/this.a,2),this.ecc2=1-this.c2a2}return i.prototype={constructor:i,convert:function(t,e){var i=t.z;if(this.longitudeFirst)var n=t.y,o=t.x;else var n=t.x,o=t.y;return this.degrees&&(n*=Math.PI/180,o*=Math.PI/180),this.convertRadians(n,o,i,e)},convertRadians:function(t,e,i,n){var o=Math.sin(t),s=Math.pow(o,2),r=Math.cos(t),a=this.a/Math.sqrt(1-this.ecc2*s),l=(a+i)*r;return n.set(l*Math.cos(e),l*Math.sin(e),(a*this.c2a2+i)*o)},apply:function(t,e){if(this.applyRadians(t,e),this.degrees&&(e.x*=180/Math.PI,e.y*=180/Math.PI),this.longitudeFirst){var i=e.x;e.x=e.y,e.y=i}return e},applyRadians:function(t,e){var i=t.x,n=t.y,o=t.z,s=Math.sqrt(i*i+n*n);if(0==s)return e.set(Math.PI,0,o-this.c);for(var r=0,a=Math.atan2(n,i),l=0,h=this.a,d=h,c=this.ecc2,u=0;u<30;++u){var p=l,g=r;r=Math.atan(o/s/(1-c*d/(d+l)));var _=Math.sin(r);if(d=h/Math.sqrt(1-c*_*_),l=s/Math.cos(r)-d,Math.abs(l-p)<.001&&Math.abs(r-g)<1e-10)break}return e.set(r,a,l)},normal:function(t,e){var i=this.applyRadians(t,e),n=i.x,o=i.y,s=Math.cos(n),r=Math.cos(o)*s,a=Math.sin(o)*s,l=Math.sin(n);return e.set(r,a,l)}},i}),t("standard/Geospatial/UniversalTransverseMercator",["standard/Geospatial/Geodetic","standard/Math/Numbers/Vector3","standard/Math/Algorithm"],function(t,e,i){"use strict";function n(e,n,s,r){var a=e.getSemiMajorAxis(),l=1-Math.pow(e.getSemiMinorAxis()/a,2),h=l/(1-l),d=(1-Math.sqrt(1-l))/(1+Math.sqrt(1-l));this.southernHemisphere=!s,this.eastingFirst=!r,this.a=a,this.ecc2=l,this.EE=h,this.E8=8*h,this.E9=9*h,this.E252=252*h,this.e1=d,this.A=o*(a*(1-l/4-3*l*l/64-5*l*l*l/256)),this.B=3*d/2-7*d*d*d/32,this.C=21*d*d/16-55*d*d*d*d/32,this.D=151*d*d*d/96,this.E=a*(1-l),this.W=1-l/4-3*l*l/64-5*l*l*l/256,this.X=3*l/8+3*l*l/32+45*l*l*l/1024,this.Y=15*l*l/256+45*l*l*l/1024,this.Z=35*l*l*l/3072,this.longitude0=i.radians(6*n-183),this.geodeticConverter=new t(e,!0,!0)}var o=.9996;return n.prototype={constructor:n,convert:function(t,e){if(this.eastingFirst)var i=t.y,n=t.x;else var i=t.x,n=t.y;var s=this.southernHemisphere;i<0&&(s=!this.southernHemisphere,i=-i),s&&(i-=1e7),n-=5e5;var r=i/this.A,a=r+this.B*Math.sin(2*r)+this.C*Math.sin(4*r)+this.D*Math.sin(6*r),l=Math.pow(Math.sin(a),2),h=Math.cos(a),d=Math.tan(a),c=this.a/Math.sqrt(1-this.ecc2*l),u=Math.pow(d,2),p=Math.pow(d,8),g=this.EE*u,_=g*g,w=this.E/Math.pow(1-this.ecc2*l,1.5),f=n/(c*o),m=(5+3*u+10*g-4*_-this.E9)*Math.pow(f,4)/24,y=(61+90*u+298*g+45*p-this.E252-3*_)*Math.pow(f,6)/720,x=(5-2*g+28*u-3*_+this.E8+24*p)*Math.pow(f,5)/120,O=a-c*d/w*(f*f/2-m+y),S=this.longitude0+(f-(1+2*u+g)*Math.pow(f,3)/6+x)/h;return this.geodeticConverter.convertRadians(O,S,t.z,e)},apply:function(t,e){var i=this.geodeticConverter.applyRadians(t,e),n=i.x,s=i.y,r=Math.tan(n),a=Math.cos(n),l=this.EE,h=this.a/Math.sqrt(1-this.ecc2*Math.pow(Math.sin(n),2)),d=r*r,c=d*d*d,u=l*a*a,p=a*(s-this.longitude0),g=this.a*(this.W*n-this.X*Math.sin(2*n)+this.Y*Math.sin(4*n)-this.Z*Math.sin(6*n)),_=o*h*(p+(1-d+u)*Math.pow(p,3)/6+(5-18*c+72*u-58*l)*Math.pow(p,5)/120)+5e5,w=o*(g+h*r*(p*p/2+(5-d+9*u+4*u*u)*Math.pow(p,4)/24+(61-58*c+600*u-330*l)*Math.pow(p,6)/720));return n<0?(w+=1e7,this.southernHemisphere||(w=-w)):this.southernHemisphere&&(w=-w),this.eastingFirst?e.set(_,w,i.z):e.set(w,_,i.z)}},n}),t("x_ite/Browser/Geospatial/Geocentric",["standard/Math/Numbers/Vector3","standard/Math/Algorithm"],function(t,e){"use strict";function i(){}return i.prototype={constructor:i,convert:function(t,e){return e.assign(t)},apply:function(t,e){return e.assign(t)},slerp:function(t,i,n){var o=t.abs(),s=i.abs();return t.normalize(),i.normalize(),e.simpleSlerp(t,i,n).multiply(e.lerp(o,s,n))}},i}),t("x_ite/Browser/Geospatial/Geospatial",["standard/Geospatial/ReferenceEllipsoids","standard/Geospatial/Geodetic","standard/Geospatial/UniversalTransverseMercator","x_ite/Browser/Geospatial/Geocentric"],function(t,e,i,n){"use strict";var o=0,s=o++,r=o++,a=o++,l={GD:s,GDC:s,UTM:r,GC:a,GCC:a,GS:a};return{GD:s,UTM:r,GC:a,getReferenceFrame:function(o,l){switch(this.getCoordinateSystem(o)){case s:return new e(this.getEllipsoid(o),this.getLatitudeFirst(o),l);case r:return new i(this.getEllipsoid(o),this.getZone(o),this.getNorthernHemisphere(o),this.getNorthingFirst(o));case a:return new n}return new e(t.WE,!0,l)},getElevationFrame:function(t,i){return new e(this.getEllipsoid(t),!0,i)},getCoordinateSystem:function(t){for(var e=0,i=t.length;e<i;++e){var n=l[t[e]];if(void 0!==n)return n}return s},getEllipsoid:function(e){for(var i=0,n=e.length;i<n;++i){var o=t[e[i]];if(void 0!==o)return o}return t.WE},getEllipsoidString:function(e){for(var i=0,n=e.length;i<n;++i){if(void 0!==t[e[i]])return e[i]}return"WE"},isStandardOrder:function(t){switch(this.getCoordinateSystem(t)){case s:return this.getLatitudeFirst(t);case r:return this.getNorthingFirst(t);case a:return!0}return this.getLatitudeFirst(t)},getLatitudeFirst:function(t){for(var e=0,i=t.length;e<i;++e)if("longitude_first"===t[e])return!1;return!0},getNorthingFirst:function(t){for(var e=0,i=t.length;e<i;++e)if("easting_first"===t[e])return!1;return!0},getZone:function(t){for(var e=0,i=t.length;e<i;++e){var n=t[e].match(/^Z(\d+)$/);if(n)return parseInt(n[1])}return 1},getNorthernHemisphere:function(t){for(var e=0,i=t.length;e<i;++e)if("S"===t[e])return!1;return!0}}}),t("x_ite/Components/Geospatial/X3DGeospatialObject",["x_ite/Bits/X3DConstants","x_ite/Browser/Geospatial/Geospatial","x_ite/Bits/X3DCast","standard/Math/Numbers/Vector3","standard/Math/Numbers/Matrix4"],function(t,e,i,n,o){"use strict";function s(e){this.addType(t.X3DGeospatialObject),this.radians=!1,this.origin=new n(0,0,0),this.originMatrix=new o,this.invOriginMatrix=new o}function r(t,e){return this.invOriginMatrix.multVecMatrix(this.referenceFrame.convert(t,e))}function a(t,e){return this.referenceFrame.apply(this.originMatrix.multVecMatrix(c.assign(t)),e)}function l(t,e){return this.invOriginMatrix.multDirMatrix(this.elevationFrame.normal(this.originMatrix.multVecMatrix(c.assign(t)),e))}function h(t,e){return d.call(this,t,e).multRight(this.invOriginMatrix)}function d(t,e){return this.referenceFrame.convert(t,p),this.elevationFrame.normal(p,_),g.set(0,0,1).cross(_),g.equals(n.Zero)&&g.set(1,0,0),w.assign(g).cross(_),g.normalize(),w.normalize(),e.set(g.x,g.y,g.z,0,_.x,_.y,_.z,0,w.x,w.y,w.z,0,p.x,p.y,p.z,1)}var c=new n(0,0,0),u=new n(0,0,0),p=new n(0,0,0),g=new n(0,0,0),_=new n(0,0,0),w=new n(0,0,0);return s.prototype={constructor:s,initialize:function(){this.geoSystem_.addInterest("set_geoSystem__",this),this.geoOrigin_.addInterest("set_geoOrigin__",this),this.set_geoSystem__(),this.set_geoOrigin__()},set_geoSystem__:function(){this.coordinateSystem=e.getCoordinateSystem(this.geoSystem_),this.referenceFrame=e.getReferenceFrame(this.geoSystem_,this.radians),this.elevationFrame=e.getElevationFrame(this.geoSystem_,this.radians),this.standardOrder=e.isStandardOrder(this.geoSystem_)},set_geoOrigin__:function(){this.geoOriginNode&&(this.geoOriginNode.removeInterest("set_origin__",this),this.geoOriginNode.removeInterest("set_rotateYUp__",this),this.geoOriginNode.removeInterest("addNodeEvent",this)),this.geoOriginNode=i(t.GeoOrigin,this.geoOrigin_),this.geoOriginNode&&(this.geoOriginNode.addInterest("set_origin__",this),this.geoOriginNode.addInterest("set_rotateYUp__",this),this.geoOriginNode.addInterest("addNodeEvent",this)),this.set_origin__(),this.set_rotateYUp__()},set_origin__:function(){this.geoOriginNode?this.geoOriginNode.getOrigin(this.origin):this.origin.set(0,0,0),this.set_originMatrix__()},set_originMatrix__:function(){try{if(this.geoOriginNode){var t=this.origin;this.elevationFrame.normal(t,_),g.set(0,0,1).cross(_),g.equals(n.Zero)&&g.set(1,0,0),w.assign(g).cross(_),g.normalize(),w.normalize(),this.originMatrix.set(g.x,g.y,g.z,0,_.x,_.y,_.z,0,w.x,w.y,w.z,0,t.x,t.y,t.z,1),this.invOriginMatrix.assign(this.originMatrix).inverse()}}catch(t){}},set_rotateYUp__:function(){this.geoOriginNode&&this.geoOriginNode.rotateYUp_.getValue()?(this.getCoord=r,this.getGeoCoord=a,this.getGeoUpVector=l,this.getLocationMatrix=h):(delete this.getCoord,delete this.getGeoCoord,delete this.getGeoUpVector,delete this.getLocationMatrix)},getReferenceFrame:function(){return this.referenceFrame},getStandardOrder:function(){return this.standardOrder},getCoord:function(t,e){return this.referenceFrame.convert(t,e).subtract(this.origin)},getGeoCoord:function(t,e){return this.referenceFrame.apply(c.assign(t).add(this.origin),e)},getGeoElevation:function(t){return this.getGeoCoord(t,u).z},getGeoUpVector:function(t,e){return this.elevationFrame.normal(c.assign(t).add(this.origin),e)},getLocationMatrix:function(t,e){var i=this.origin,n=d.call(this,t,e);return n[12]-=i.x,n[13]-=i.y,n[14]-=i.z,n}},s}),t("x_ite/Components/Geospatial/GeoCoordinate",["x_ite/Fields","x_ite/Basic/X3DFieldDefinition","x_ite/Basic/FieldDefinitionArray","x_ite/Components/Rendering/X3DCoordinateNode","x_ite/Components/Geospatial/X3DGeospatialObject","x_ite/Bits/X3DConstants","standard/Math/Geometry/Triangle3","standard/Math/Numbers/Vector3"],function(t,e,i,n,o,s,r,a){"use strict";function l(t){n.call(this,t),o.call(this,t),this.addType(s.GeoCoordinate)}return l.prototype=Object.assign(Object.create(n.prototype),o.prototype,{constructor:l,fieldDefinitions:new i([new e(s.inputOutput,"metadata",new t.SFNode),new e(s.initializeOnly,"geoOrigin",new t.SFNode),new e(s.initializeOnly,"geoSystem",new t.MFString("GD","WE")),new e(s.inputOutput,"point",new t.MFVec3d)]),getTypeName:function(){return"GeoCoordinate"},getComponentName:function(){return"Geospatial"},getContainerField:function(){return"coord"},initialize:function(){n.prototype.initialize.call(this),o.prototype.initialize.call(this),this.point_.addInterest("set_point__",this),this.set_point__()},set_point__:function(){this.point=this.point_.getValue(),this.length=this.point_.length},isEmpty:function(){return 0===this.length},getSize:function(){return this.length},set1Point:function(){var t=new a(0,0,0);return function(e,i){this.point_[e]=this.getGeoCoord(i,t)}}(),get1Point:function(){var t=new a(0,0,0);return function(e,i){if(e<this.length){const n=this.point;return e*=3,this.getCoord(t.set(n[e],n[e+1],n[e+2]),i)}return i.set(0,0,0)}}(),addPoint:function(){var t=new a(0,0,0),e=new a(0,0,0);return function(i,n){if(i<this.length){const o=this.point;i*=3,this.getCoord(t.set(o[i],o[i+1],o[i+2]),e),n.push(e[0],e[1],e[2],1)}else n.push(0,0,0,1)}}(),addPoints:function(){var t=new a(0,0,0),e=new a(0,0,0);return function(i,n){const o=this.point;for(var s=0,r=3*this.length;s<r;s+=3)this.getCoord(t.set(o[s],o[s+1],o[s+2]),e),i.push(e[0],e[1],e[2],1);for(var s=r,r=3*n;s<r;s+=3)i.push(0,0,0,1)}}(),getNormal:function(){var t=new a(0,0,0),e=new a(0,0,0),i=new a(0,0,0);return function(n,o,s){var l=this.length;return n<l&&o<l&&s<l?r.normal(this.get1Point(n,t),this.get1Point(o,e),this.get1Point(s,i),new a(0,0,0)):new a(0,0,0)}}(),getQuadNormal:function(){var t=new a(0,0,0),e=new a(0,0,0),i=new a(0,0,0),n=new a(0,0,0);return function(o,s,l,h){var d=this.length;return o<d&&s<d&&l<d&&h<d?r.quadNormal(this.get1Point(o,t),this.get1Point(s,e),this.get1Point(l,i),this.get1Point(h,n),new a(0,0,0)):new a(0,0,0)}}()}),l}),t("x_ite/Components/Geospatial/GeoElevationGrid",["x_ite/Fields","x_ite/Basic/X3DFieldDefinition","x_ite/Basic/FieldDefinitionArray","x_ite/Components/Rendering/X3DGeometryNode","x_ite/Components/Geospatial/X3DGeospatialObject","x_ite/Bits/X3DConstants","x_ite/Bits/X3DCast","standard/Math/Geometry/Triangle3","standard/Math/Numbers/Vector2","standard/Math/Numbers/Vector3"],function(t,e,i,n,o,s,r,a,l,h){"use strict";function d(t){n.call(this,t),o.call(this,t),this.addType(s.GeoElevationGrid),this.creaseAngle_.setUnit("angle"),this.height_.setUnit("length"),this.colorNode=null,this.texCoordNode=null,this.normalNode=null}return d.prototype=Object.assign(Object.create(n.prototype),o.prototype,{constructor:d,fieldDefinitions:new i([new e(s.inputOutput,"metadata",new t.SFNode),new e(s.initializeOnly,"geoOrigin",new t.SFNode),new e(s.initializeOnly,"geoSystem",new t.MFString("GD","WE")),new e(s.initializeOnly,"geoGridOrigin",new t.SFVec3d),new e(s.initializeOnly,"xDimension",new t.SFInt32),new e(s.initializeOnly,"zDimension",new t.SFInt32),new e(s.initializeOnly,"xSpacing",new t.SFDouble(1)),new e(s.initializeOnly,"zSpacing",new t.SFDouble(1)),new e(s.inputOutput,"yScale",new t.SFFloat(1)),new e(s.initializeOnly,"solid",new t.SFBool(!0)),new e(s.initializeOnly,"ccw",new t.SFBool(!0)),new e(s.initializeOnly,"creaseAngle",new t.SFDouble),new e(s.initializeOnly,"colorPerVertex",new t.SFBool(!0)),new e(s.initializeOnly,"normalPerVertex",new t.SFBool(!0)),new e(s.inputOutput,"color",new t.SFNode),new e(s.inputOutput,"texCoord",new t.SFNode),new e(s.inputOutput,"normal",new t.SFNode),new e(s.inputOutput,"height",new t.MFDouble(0,0))]),getTypeName:function(){return"GeoElevationGrid"},getComponentName:function(){return"Geospatial"},getContainerField:function(){return"geometry"},initialize:function(){n.prototype.initialize.call(this),o.prototype.initialize.call(this),this.color_.addInterest("set_color__",this),this.texCoord_.addInterest("set_texCoord__",this),this.normal_.addInterest("set_normal__",this),this.set_color__(),this.set_texCoord__(),this.set_normal__()},set_color__:function(){this.colorNode&&(this.colorNode.removeInterest("requestRebuild",this),this.colorNode.removeInterest("set_transparent__",this)),this.colorNode=r(s.X3DColorNode,this.color_),this.colorNode?(this.colorNode.addInterest("requestRebuild",this),this.colorNode.addInterest("set_transparent__",this),this.set_transparent__()):this.transparent_=!1},set_transparent__:function(){this.transparent_=this.colorNode.isTransparent()},set_texCoord__:function(){this.texCoordNode&&this.texCoordNode.removeInterest("requestRebuild",this),this.texCoordNode=r(s.X3DTextureCoordinateNode,this.texCoord_),this.texCoordNode&&this.texCoordNode.addInterest("requestRebuild",this),this.setCurrentTexCoord(this.texCoordNode)},set_normal__:function(){this.normalNode&&this.normalNode.removeInterest("requestRebuild",this),this.normalNode=r(s.X3DNormalNode,this.normal_),this.normalNode&&this.normalNode.addInterest("requestRebuild",this)},getColor:function(){return this.colorNode},getTexCoord:function(){return this.texCoordNode},getNormal:function(){return this.normalNode},getHeight:function(t){return t<this.height_.length?this.height_[t]*this.yScale_.getValue():0},createTexCoords:function(){for(var t=[],e=this.xDimension_.getValue(),i=this.zDimension_.getValue(),n=e-1,o=i-1,s=0;s<i;++s)for(var r=0;r<e;++r)t.push(new l(r/n,s/o));return t},createNormals:function(t,e,i){for(var n=!this.ccw_.getValue(),o=[],s=[],r=0;r<t.length;++r)o[r]=[];for(var l=0;l<e.length;l+=3){var d=e[l],c=e[l+1],u=e[l+2];o[d].push(s.length),o[c].push(s.length+1),o[u].push(s.length+2);var p=a.normal(t[d],t[c],t[u],new h(0,0,0));n&&p.negate(),s.push(p),s.push(p),s.push(p)}return this.refineNormals(o,s,this.creaseAngle_.getValue())},createCoordIndex:function(){for(var t=[],e=this.xDimension_.getValue(),i=this.zDimension_.getValue(),n=e-1,o=i-1,s=0;s<o;++s)for(var r=0;r<n;++r){var a=s*e+r,l=(s+1)*e+r,h=(s+1)*e+(r+1),d=s*e+(r+1);t.push(a),t.push(h),t.push(l),t.push(a),t.push(d),t.push(h)}return t},createPoints:function(){var t=[],e=this.xDimension_.getValue(),i=this.zDimension_.getValue(),n=this.xSpacing_.getValue(),o=this.zSpacing_.getValue();if(this.getStandardOrder())for(var s=0;s<i;++s)for(var r=0;r<e;++r){var a=new h(o*s,n*r,this.getHeight(r+s*e));a.add(this.geoGridOrigin_.getValue()),t.push(this.getCoord(a,a))}else for(var s=0;s<i;++s)for(var r=0;r<e;++r){var a=new h(n*r,o*s,this.getHeight(r+s*e));a.add(this.geoGridOrigin_.getValue()),t.push(this.getCoord(a,a))}return t},build:function(){if(!(this.xDimension_.getValue()<2||this.zDimension_.getValue()<2)){var t=this.colorPerVertex_.getValue(),e=this.normalPerVertex_.getValue(),i=this.createCoordIndex(),n=this.getColor(),o=this.getTexCoord(),s=this.getNormal(),r=this.createPoints(),a=this.getColors(),l=this.getMultiTexCoords(),h=this.getNormals(),d=this.getVertices(),c=0;if(o)o.init(l);else{var u=this.createTexCoords(),p=this.getTexCoords();l.push(p)}for(var g=0;g<i.length;++c)for(var _=0;_<6;++_,++g){var w=i[g],f=r[w];if(n&&(t?n.addColor(w,a):n.addColor(c,a)),o)o.addTexCoord(w,l);else{var m=u[w];p.push(m.x,m.y,0,1)}s&&(e?s.addVector(w,h):s.addVector(c,h)),d.push(f.x,f.y,f.z,1)}if(!s)for(var y=this.createNormals(r,i),x=0;x<y.length;++x){var O=y[x];h.push(O.x,O.y,O.z)}this.setSolid(this.solid_.getValue()),this.setCCW(this.ccw_.getValue())}}}),d}),t("x_ite/Components/Geospatial/GeoLOD",["x_ite/Fields","x_ite/Basic/X3DFieldDefinition","x_ite/Basic/FieldDefinitionArray","x_ite/Components/Core/X3DChildNode","x_ite/Components/Grouping/X3DBoundedObject","x_ite/Components/Geospatial/X3DGeospatialObject","x_ite/Bits/X3DConstants","x_ite/Bits/TraverseType","x_ite/Components/Grouping/Group","x_ite/Components/Networking/Inline","standard/Math/Numbers/Vector3","standard/Math/Numbers/Matrix4","standard/Math/Geometry/Box3"],function(t,e,i,n,o,s,r,a,l,h,d,c,u){"use strict";function p(t){n.call(this,t),o.call(this,t),s.call(this,t),this.addType(r.GeoLOD),this.range_.setUnit("length"),this.rootGroup=new l(this.getBrowser().getPrivateScene()),this.rootInline=new h(t),this.child1Inline=new h(t),this.child2Inline=new h(t),this.child3Inline=new h(t),this.child4Inline=new h(t),this.childrenLoaded=!1,this.childBBox=new u,this.keepCurrentLevel=!1,this.modelViewMatrix=new c}var g=new d(0,0,0);return p.prototype=Object.assign(Object.create(n.prototype),o.prototype,s.prototype,{constructor:p,fieldDefinitions:new i([new e(r.inputOutput,"metadata",new t.SFNode),new e(r.initializeOnly,"geoOrigin",new t.SFNode),new e(r.initializeOnly,"geoSystem",new t.MFString("GD","WE")),new e(r.initializeOnly,"rootUrl",new t.MFString),new e(r.initializeOnly,"child1Url",new t.MFString),new e(r.initializeOnly,"child2Url",new t.MFString),new e(r.initializeOnly,"child3Url",new t.MFString),new e(r.initializeOnly,"child4Url",new t.MFString),new e(r.initializeOnly,"center",new t.SFVec3d),new e(r.initializeOnly,"range",new t.SFFloat(10)),new e(r.outputOnly,"level_changed",new t.SFInt32(-1)),new e(r.initializeOnly,"rootNode",new t.MFNode),new e(r.initializeOnly,"bboxSize",new t.SFVec3f(-1,-1,-1)),new e(r.initializeOnly,"bboxCenter",new t.SFVec3f),new e(r.outputOnly,"children",new t.MFNode)]),getTypeName:function(){return"GeoLOD"},getComponentName:function(){return"Geospatial"},getContainerField:function(){return"children"},initialize:function(){n.prototype.initialize.call(this),o.prototype.initialize.call(this),s.prototype.initialize.call(this),this.rootNode_.addFieldInterest(this.rootGroup.children_),this.rootGroup.children_=this.rootNode_,this.rootGroup.setPrivate(!0),this.rootGroup.setup(),this.rootInline.loadState_.addInterest("set_rootLoadState__",this),this.child1Inline.loadState_.addInterest("set_childLoadState__",this),this.child2Inline.loadState_.addInterest("set_childLoadState__",this),this.child3Inline.loadState_.addInterest("set_childLoadState__",this),this.child4Inline.loadState_.addInterest("set_childLoadState__",this),this.rootUrl_.addFieldInterest(this.rootInline.url_),this.child1Url_.addFieldInterest(this.child1Inline.url_),this.child2Url_.addFieldInterest(this.child2Inline.url_),this.child3Url_.addFieldInterest(this.child3Inline.url_),this.child4Url_.addFieldInterest(this.child4Inline.url_),this.rootInline.load_=!0,this.child1Inline.load_=!1,this.child2Inline.load_=!1,this.child3Inline.load_=!1,this.child4Inline.load_=!1,this.rootInline.url_=this.rootUrl_,this.child1Inline.url_=this.child1Url_,this.child2Inline.url_=this.child2Url_,this.child3Inline.url_=this.child3Url_,this.child4Inline.url_=this.child4Url_,this.rootInline.setup(),this.child1Inline.setup(),this.child2Inline.setup(),this.child3Inline.setup(),this.child4Inline.setup()},getBBox:function(t){if(this.bboxSize_.getValue().equals(this.defaultBBoxSize)){var e=this.level_changed_.getValue();switch(this.childrenLoaded?e:0){case 0:return this.rootNode_.length?this.rootGroup.getBBox(t):this.rootInline.getBBox(t);case 1:return t.set(),t.add(this.child1Inline.getBBox(this.childBBox)),t.add(this.child2Inline.getBBox(this.childBBox)),t.add(this.child3Inline.getBBox(this.childBBox)),t.add(this.child4Inline.getBBox(this.childBBox)),t}return t.set()}return t.set(this.bboxSize_.getValue(),this.bboxCenter_.getValue())},set_rootLoadState__:function(){0===this.level_changed_.getValue()&&(this.rootNode_.length||this.rootInline.checkLoadState()===r.COMPLETE_STATE&&(this.children_=this.rootInline.getInternalScene().getRootNodes(),this.childrenLoaded=!1))},set_childLoadState__:function(){var e=new t.MFNode;return function(){if(1===this.level_changed_.getValue()){var t=0;if(this.child1Inline.checkLoadState()===r.COMPLETE_STATE){for(var i=this.child1Inline.getInternalScene().getRootNodes(),n=0,o=i.length;n<o;++n)e.push(i[n]);++t}else this.child1Inline.checkLoadState()===r.FAILED_STATE&&++t;if(this.child2Inline.checkLoadState()===r.COMPLETE_STATE){for(var i=this.child2Inline.getInternalScene().getRootNodes(),n=0,o=i.length;n<o;++n)e.push(i[n]);++t}else this.child2Inline.checkLoadState()===r.FAILED_STATE&&++t;if(this.child3Inline.checkLoadState()===r.COMPLETE_STATE){for(var i=this.child3Inline.getInternalScene().getRootNodes(),n=0,o=i.length;n<o;++n)e.push(i[n]);++t}else this.child3Inline.checkLoadState()===r.FAILED_STATE&&++t;if(this.child4Inline.checkLoadState()===r.COMPLETE_STATE){for(var i=this.child4Inline.getInternalScene().getRootNodes(),n=0,o=i.length;n<o;++n)e.push(i[n]);++t}else this.child4Inline.checkLoadState()===r.FAILED_STATE&&++t;4===t&&(this.childrenLoaded=!0,this.children_.assign(e))}}}(),getLevel:function(t){return this.getDistance(t)<this.range_.getValue()?1:0},getDistance:function(t){return t.translate(this.getCoord(this.center_.getValue(),g)),t.origin.abs()},traverse:function(t,e){if(t==a.DISPLAY){var i=this.getLevel(this.modelViewMatrix.assign(e.getModelViewMatrix().get()));if(i!==this.level_changed_.getValue())switch(this.level_changed_=i,i){case 0:this.rootNode_.length?(this.children_=this.rootNode_,this.childrenLoaded=!1):this.rootInline.checkLoadState()==r.COMPLETE_STATE&&(this.children_=this.rootInline.getInternalScene().getRootNodes(),this.childrenLoaded=!1),this.child1Inline.load_=!1,this.child2Inline.load_=!1,this.child3Inline.load_=!1,this.child4Inline.load_=!1;break;case 1:this.child1Inline.load_=!0,this.child2Inline.load_=!0,this.child3Inline.load_=!0,this.child4Inline.load_=!0}}switch(this.childrenLoaded?this.level_changed_.getValue():0){case 0:this.rootNode_.length?this.rootGroup.traverse(t,e):this.rootInline.traverse(t,e);break;case 1:this.child1Inline.traverse(t,e),this.child2Inline.traverse(t,e),this.child3Inline.traverse(t,e),this.child4Inline.traverse(t,e)}}}),p}),t("x_ite/Components/Geospatial/GeoLocation",["x_ite/Fields","x_ite/Basic/X3DFieldDefinition","x_ite/Basic/FieldDefinitionArray","x_ite/Components/Grouping/X3DTransformMatrix3DNode","x_ite/Components/Geospatial/X3DGeospatialObject","x_ite/Bits/X3DConstants","standard/Math/Numbers/Matrix4"],function(t,e,i,n,o,s,r){"use strict";function a(t){n.call(this,t),o.call(this,t),this.addType(s.GeoLocation)}var l=new r;return a.prototype=Object.assign(Object.create(n.prototype),o.prototype,{constructor:a,fieldDefinitions:new i([new e(s.inputOutput,"metadata",new t.SFNode),new e(s.initializeOnly,"geoSystem",new t.MFString("GD","WE")),new e(s.inputOutput,"geoCoords",new t.SFVec3d),new e(s.initializeOnly,"geoOrigin",new t.SFNode),new e(s.initializeOnly,"bboxSize",new t.SFVec3f(-1,-1,-1)),new e(s.initializeOnly,"bboxCenter",new t.SFVec3f),new e(s.inputOnly,"addChildren",new t.MFNode),new e(s.inputOnly,"removeChildren",new t.MFNode),new e(s.inputOutput,"children",new t.MFNode)]),getTypeName:function(){return"GeoLocation"},getComponentName:function(){return"Geospatial"},getContainerField:function(){return"children"},initialize:function(){n.prototype.initialize.call(this),o.prototype.initialize.call(this),this.addInterest("eventsProcessed",this),this.eventsProcessed()},eventsProcessed:function(){this.setMatrix(this.getLocationMatrix(this.geoCoords_.getValue(),l))}}),a}),t("x_ite/Components/Geospatial/GeoMetadata",["x_ite/Fields","x_ite/Basic/X3DFieldDefinition","x_ite/Basic/FieldDefinitionArray","x_ite/Components/Core/X3DInfoNode","x_ite/Bits/X3DConstants"],function(t,e,i,n,o){"use strict";function s(t){n.call(this,t),this.addType(o.GeoMetadata)}return s.prototype=Object.assign(Object.create(n.prototype),{constructor:s,fieldDefinitions:new i([new e(o.inputOutput,"metadata",new t.SFNode),new e(o.inputOutput,"url",new t.MFString),new e(o.inputOutput,"summary",new t.MFString),new e(o.inputOutput,"data",new t.MFNode)]),getTypeName:function(){return"GeoMetadata"},getComponentName:function(){return"Geospatial"},getContainerField:function(){return"children"}}),s}),t("x_ite/Components/Geospatial/GeoOrigin",["x_ite/Fields","x_ite/Basic/X3DFieldDefinition","x_ite/Basic/FieldDefinitionArray","x_ite/Components/Core/X3DNode","x_ite/Bits/X3DConstants","x_ite/Browser/Geospatial/Geospatial"],function(t,e,i,n,o,s){"use strict";function r(t){n.call(this,t),this.addType(o.GeoOrigin),this.radians=!1}return r.prototype=Object.assign(Object.create(n.prototype),{constructor:r,fieldDefinitions:new i([new e(o.inputOutput,"metadata",new t.SFNode),new e(o.initializeOnly,"geoSystem",new t.MFString("GD","WE")),new e(o.inputOutput,"geoCoords",new t.SFVec3d),new e(o.initializeOnly,"rotateYUp",new t.SFBool)]),getTypeName:function(){return"GeoOrigin"},getComponentName:function(){return"Geospatial"},getContainerField:function(){return"geoOrigin"},initialize:function(){n.prototype.initialize.call(this),this.geoSystem_.addInterest("set_geoSystem__",this),this.set_geoSystem__()},set_geoSystem__:function(){this.referenceFrame=s.getReferenceFrame(this.geoSystem_,this.radians)},getOrigin:function(t){return this.referenceFrame.convert(this.geoCoords_.getValue(),t)}}),r}),t("x_ite/Components/Geospatial/GeoPositionInterpolator",["x_ite/Fields","x_ite/Basic/X3DFieldDefinition","x_ite/Basic/FieldDefinitionArray","x_ite/Components/Interpolation/X3DInterpolatorNode","x_ite/Components/Geospatial/X3DGeospatialObject","x_ite/Browser/Geospatial/Geocentric","x_ite/Bits/X3DConstants","standard/Math/Numbers/Vector3"],function(t,e,i,n,o,s,r,a){"use strict";function l(t){n.call(this,t),o.call(this,t),this.addType(r.GeoPositionInterpolator),this.value_changed_.setUnit("length"),this.geocentric=new s}return l.prototype=Object.assign(Object.create(n.prototype),o.prototype,{constructor:l,fieldDefinitions:new i([new e(r.inputOutput,"metadata",new t.SFNode),new e(r.initializeOnly,"geoOrigin",new t.SFNode),new e(r.initializeOnly,"geoSystem",new t.MFString("GD","WE")),new e(r.inputOnly,"set_fraction",new t.SFFloat),new e(r.inputOutput,"key",new t.MFFloat),new e(r.inputOutput,"keyValue",new t.MFVec3d),new e(r.outputOnly,"value_changed",new t.SFVec3d),new e(r.outputOnly,"geovalue_changed",new t.SFVec3d)]),keyValue0:new a(0,0,0),keyValue1:new a(0,0,0),geovalue:new a(0,0,0),value:new a(0,0,0),getTypeName:function(){return"GeoPositionInterpolator"},getComponentName:function(){return"Geospatial"},getContainerField:function(){return"children"},setup:function(){o.prototype.initialize.call(this),n.prototype.setup.call(this)},initialize:function(){n.prototype.initialize.call(this),this.keyValue_.addInterest("set_keyValue__",this)},set_keyValue__:function(){var e=this.key_,i=this.keyValue_;i.length<e.length&&i.resize(e.length,i.length?i[i.length-1]:new t.SFVec3f)},interpolate:function(t,e,i){try{this.getCoord(this.keyValue_[t].getValue(),this.keyValue0),this.getCoord(this.keyValue_[e].getValue(),this.keyValue1);var n=this.geocentric.slerp(this.keyValue0,this.keyValue1,i);this.geovalue_changed_=this.getGeoCoord(n,this.geovalue),this.value_changed_=n}catch(t){}}}),l}),t("x_ite/Components/Geospatial/GeoProximitySensor",["x_ite/Fields","x_ite/Basic/X3DFieldDefinition","x_ite/Basic/FieldDefinitionArray","x_ite/Components/EnvironmentalSensor/X3DEnvironmentalSensorNode","x_ite/Components/Geospatial/X3DGeospatialObject","x_ite/Components/EnvironmentalSensor/ProximitySensor","x_ite/Bits/X3DConstants","standard/Math/Numbers/Vector3"],function(t,e,i,n,o,s,r,a){"use strict";function l(t){n.call(this,t),o.call(this,t),this.addType(r.GeoProximitySensor),this.position_changed_.setUnit("length"),this.centerOfRotation_changed_.setUnit("length"),this.proximitySensor=new s(t),this.setCameraObject(this.proximitySensor.getCameraObject())}var h=new a(0,0,0);return l.prototype=Object.assign(Object.create(n.prototype),o.prototype,{constructor:l,fieldDefinitions:new i([new e(r.inputOutput,"metadata",new t.SFNode),new e(r.initializeOnly,"geoOrigin",new t.SFNode),new e(r.initializeOnly,"geoSystem",new t.MFString("GD","WE")),new e(r.inputOutput,"enabled",new t.SFBool(!0)),new e(r.inputOutput,"size",new t.SFVec3f),new e(r.inputOutput,"center",new t.SFVec3f),new e(r.outputOnly,"isActive",new t.SFBool),new e(r.outputOnly,"enterTime",new t.SFTime),new e(r.outputOnly,"exitTime",new t.SFTime),new e(r.outputOnly,"geoCoord_changed",new t.SFVec3d),new e(r.outputOnly,"position_changed",new t.SFVec3f),new e(r.outputOnly,"orientation_changed",new t.SFRotation),new e(r.outputOnly,"centerOfRotation_changed",new t.SFVec3f)]),getTypeName:function(){return"GeoProximitySensor"},getComponentName:function(){return"Geospatial"},getContainerField:function(){return"children"},initialize:function(){n.prototype.initialize.call(this),o.prototype.initialize.call(this),this.enabled_.addFieldInterest(this.proximitySensor.enabled_),this.size_.addFieldInterest(this.proximitySensor.size_),this.center_.addFieldInterest(this.proximitySensor.center_),this.proximitySensor.isCameraObject_.addFieldInterest(this.isCameraObject_),this.proximitySensor.isActive_.addFieldInterest(this.isActive_),this.proximitySensor.enterTime_.addFieldInterest(this.enterTime_),this.proximitySensor.exitTime_.addFieldInterest(this.exitTime_),
this.proximitySensor.position_changed_.addFieldInterest(this.position_changed_),this.proximitySensor.orientation_changed_.addFieldInterest(this.orientation_changed_),this.proximitySensor.centerOfRotation_changed_.addFieldInterest(this.centerOfRotation_changed_),this.proximitySensor.position_changed_.addInterest("set_position__",this),this.proximitySensor.enabled_=this.enabled_,this.proximitySensor.size_=this.size_,this.proximitySensor.center_=this.center_,this.proximitySensor.setup()},set_position__:function(t){this.geoCoord_changed_=this.getGeoCoord(this.proximitySensor.position_changed_.getValue(),h)},traverse:function(t,e){this.proximitySensor.traverse(t,e)}}),l}),t("x_ite/Components/Geospatial/GeoTouchSensor",["x_ite/Fields","x_ite/Basic/X3DFieldDefinition","x_ite/Basic/FieldDefinitionArray","x_ite/Components/PointingDeviceSensor/X3DTouchSensorNode","x_ite/Components/Geospatial/X3DGeospatialObject","x_ite/Bits/X3DConstants","standard/Math/Numbers/Vector3","standard/Math/Numbers/Matrix4"],function(t,e,i,n,o,s,r,a){"use strict";function l(t){n.call(this,t),o.call(this,t),this.addType(s.GeoTouchSensor),this.hitPoint_changed_.setUnit("length")}var h=new a,d=new r(0,0,0);return l.prototype=Object.assign(Object.create(n.prototype),o.prototype,{constructor:l,fieldDefinitions:new i([new e(s.inputOutput,"metadata",new t.SFNode),new e(s.initializeOnly,"geoOrigin",new t.SFNode),new e(s.initializeOnly,"geoSystem",new t.MFString("GD","WE")),new e(s.inputOutput,"enabled",new t.SFBool(!0)),new e(s.inputOutput,"description",new t.SFString),new e(s.outputOnly,"hitTexCoord_changed",new t.SFVec2f),new e(s.outputOnly,"hitNormal_changed",new t.SFVec3f),new e(s.outputOnly,"hitPoint_changed",new t.SFVec3f),new e(s.outputOnly,"hitGeoCoord_changed",new t.SFVec3d),new e(s.outputOnly,"isOver",new t.SFBool),new e(s.outputOnly,"isActive",new t.SFBool),new e(s.outputOnly,"touchTime",new t.SFTime)]),getTypeName:function(){return"GeoTouchSensor"},getComponentName:function(){return"Geospatial"},getContainerField:function(){return"children"},initialize:function(){n.prototype.initialize.call(this),o.prototype.initialize.call(this)},set_over__:function(t,e,i,o,s){try{if(n.prototype.set_over__.call(this,t,e,i,o,s),this.isOver_.getValue()){var r=e.intersection;h.assign(i).inverse(),this.hitTexCoord_changed_=r.texCoord,this.hitNormal_changed_=i.multMatrixDir(r.normal.copy()).normalize(),this.hitPoint_changed_=h.multVecMatrix(r.point.copy()),this.hitGeoCoord_changed_=this.getGeoCoord(this.hitPoint_changed_.getValue(),d)}}catch(t){console.log(t)}}}),l}),t("x_ite/Components/Geospatial/GeoTransform",["x_ite/Fields","x_ite/Basic/X3DFieldDefinition","x_ite/Basic/FieldDefinitionArray","x_ite/Components/Grouping/X3DTransformMatrix3DNode","x_ite/Components/Geospatial/X3DGeospatialObject","x_ite/Bits/X3DConstants","standard/Math/Numbers/Matrix4"],function(t,e,i,n,o,s,r){"use strict";function a(t){n.call(this,t),o.call(this,t),this.addType(s.GeoTransform),this.translation_.setUnit("length")}var l=new r,h=new r;return a.prototype=Object.assign(Object.create(n.prototype),o.prototype,{constructor:a,fieldDefinitions:new i([new e(s.inputOutput,"metadata",new t.SFNode),new e(s.inputOutput,"translation",new t.SFVec3f),new e(s.inputOutput,"rotation",new t.SFRotation),new e(s.inputOutput,"scale",new t.SFVec3f(1,1,1)),new e(s.inputOutput,"scaleOrientation",new t.SFRotation),new e(s.initializeOnly,"geoOrigin",new t.SFNode),new e(s.initializeOnly,"geoSystem",new t.MFString("GD","WE")),new e(s.inputOutput,"geoCenter",new t.SFVec3d),new e(s.initializeOnly,"bboxSize",new t.SFVec3f(-1,-1,-1)),new e(s.initializeOnly,"bboxCenter",new t.SFVec3f),new e(s.inputOnly,"addChildren",new t.MFNode),new e(s.inputOnly,"removeChildren",new t.MFNode),new e(s.inputOutput,"children",new t.MFNode)]),getTypeName:function(){return"GeoTransform"},getComponentName:function(){return"Geospatial"},getContainerField:function(){return"children"},initialize:function(){n.prototype.initialize.call(this),o.prototype.initialize.call(this),this.addInterest("eventsProcessed",this),this.eventsProcessed()},eventsProcessed:function(){try{this.setHidden(0===this.scale_.x||0===this.scale_.y||0===this.scale_.z),this.getLocationMatrix(this.geoCenter_.getValue(),h),l.set(this.translation_.getValue(),this.rotation_.getValue(),this.scale_.getValue(),this.scaleOrientation_.getValue()),this.setMatrix(l.multRight(h).multLeft(h.inverse()))}catch(t){this.setHidden(!0)}}}),a}),t("x_ite/Components/Geospatial/GeoViewpoint",["x_ite/Fields","x_ite/Basic/X3DFieldDefinition","x_ite/Basic/FieldDefinitionArray","x_ite/Components/Navigation/X3DViewpointNode","x_ite/Components/Geospatial/X3DGeospatialObject","x_ite/Components/Interpolation/ScalarInterpolator","x_ite/Components/Navigation/NavigationInfo","x_ite/Bits/X3DConstants","standard/Math/Geometry/Camera","standard/Math/Numbers/Vector2","standard/Math/Numbers/Vector3","standard/Math/Numbers/Rotation4","standard/Math/Numbers/Matrix4","standard/Math/Algorithm"],function(t,e,i,n,o,s,r,a,l,h,d,c,u,p){"use strict";function g(t,e){n.prototype.traverse.call(this,t,e),this.navigationInfoNode.traverse(t,e)}function _(t){switch(n.call(this,t),o.call(this,t),this.addType(a.GeoViewpoint),this.centerOfRotation_.setUnit("length"),this.fieldOfView_.setUnit("angle"),this.navigationInfoNode=new r(t),this.fieldOfViewInterpolator=new s(this.getBrowser().getPrivateScene()),this.projectionMatrix=new u,this.elevation=0,t.specificationVersion){case"2.0":case"3.0":case"3.1":case"3.2":this.traverse=g}}return _.prototype=Object.assign(Object.create(n.prototype),o.prototype,{constructor:_,fieldDefinitions:new i([new e(a.inputOutput,"metadata",new t.SFNode),new e(a.initializeOnly,"geoOrigin",new t.SFNode),new e(a.initializeOnly,"geoSystem",new t.MFString("GD","WE")),new e(a.inputOnly,"set_bind",new t.SFBool),new e(a.inputOutput,"description",new t.SFString),new e(a.inputOutput,"position",new t.SFVec3d(0,0,1e5)),new e(a.inputOutput,"orientation",new t.SFRotation),new e(a.inputOutput,"centerOfRotation",new t.SFVec3d),new e(a.inputOutput,"fieldOfView",new t.SFFloat(.7854)),new e(a.inputOutput,"jump",new t.SFBool(!0)),new e(a.inputOutput,"retainUserOffsets",new t.SFBool),new e(a.inputOutput,"navType",new t.MFString("EXAMINE","ANY")),new e(a.inputOutput,"headlight",new t.SFBool(!0)),new e(a.initializeOnly,"speedFactor",new t.SFFloat(1)),new e(a.outputOnly,"isBound",new t.SFBool),new e(a.outputOnly,"bindTime",new t.SFTime)]),getTypeName:function(){return"GeoViewpoint"},getComponentName:function(){return"Geospatial"},getContainerField:function(){return"children"},initialize:function(){n.prototype.initialize.call(this),o.prototype.initialize.call(this),this.position_.addInterest("set_position__",this),this.positionOffset_.addInterest("set_position__",this),this.navType_.addFieldInterest(this.navigationInfoNode.type_),this.headlight_.addFieldInterest(this.navigationInfoNode.headlight_),this.navigationInfoNode.setup(),this.set_position__(),this.fieldOfViewInterpolator.key_=[0,1],this.fieldOfViewInterpolator.setup(),this.getEaseInEaseOut().modifiedFraction_changed_.addFieldInterest(this.fieldOfViewInterpolator.set_fraction_),this.fieldOfViewInterpolator.value_changed_.addFieldInterest(this.fieldOfViewScale_)},setInterpolators:function(t){if(t.getType().indexOf(a.GeoViewpoint)<0)this.fieldOfViewInterpolator.keyValue_=[this.fieldOfViewScale_.getValue(),this.fieldOfViewScale_.getValue()];else{var e=t.getFieldOfView()/this.fieldOfView_.getValue();this.fieldOfViewInterpolator.keyValue_=[e,this.fieldOfViewScale_.getValue()],this.fieldOfViewScale_=e}},setPosition:function(){var t=new d(0,0,0);return function(e){this.position_.setValue(this.getGeoCoord(e,t))}}(),getPosition:function(){var t=new d(0,0,0);return function(){return this.getCoord(this.position_.getValue(),t)}}(),set_position__:function(){var t=new d(0,0,0);return function(){this.getCoord(this.position_.getValue(),t),this.elevation=this.getGeoElevation(t.add(this.positionOffset_.getValue()))}}(),setOrientation:function(){var t=new u,e=new c(0,0,1,0);return function(i){var n=this.getLocationMatrix(this.position_.getValue(),t).submatrix;e.setMatrix(n),this.orientation_.setValue(e.inverse().multLeft(i))}}(),getOrientation:function(){var t=new u,e=new c(0,0,1,0);return function(){var i=this.getLocationMatrix(this.position_.getValue(),t).submatrix;return e.setMatrix(i),e.multLeft(this.orientation_.getValue())}}(),getCenterOfRotation:function(){var t=new d(0,0,0);return function(){return this.getCoord(this.centerOfRotation_.getValue(),t)}}(),getFieldOfView:function(){var t=this.fieldOfView_*this.fieldOfViewScale_;return t>0&&t<Math.PI?t:Math.PI/4},getMaxFarValue:function(){return this.getBrowser().getRenderingProperty("LogarithmicDepthBuffer")?1e10:1e9},getUpVector:function(){var t=new d(0,0,0),e=new d(0,0,0);return function(){return this.getCoord(this.position_.getValue(),t),this.getGeoUpVector.call(this,t.add(this.positionOffset_.getValue()),e)}}(),getSpeedFactor:function(){return(Math.max(this.elevation,0)+10)/10*this.speedFactor_.getValue()},getScreenScale:function(){var t=new d(0,0,0);return function(e,i){var n=i[2],o=i[3],s=Math.abs(e.z)*Math.tan(this.getFieldOfView()/2)*2;return s/=n>o?o:n,t.set(s,s,s)}}(),getViewportSize:function(){var t=new h(0,0);return function(e,i){var n=e[2],o=e[3],s=i*Math.tan(this.getFieldOfView()/2)*2,r=n/o;return r>1?t.set(s*r,s):t.set(s,s/r)}}(),getLookAtDistance:function(t){return t.size.abs()/2/Math.tan(this.getFieldOfView()/2)},getProjectionMatrixWithLimits:function(t,e,i,n){if(n||this.getBrowser().getRenderingProperty("LogarithmicDepthBuffer"))return l.perspective(this.getFieldOfView(),t,e,i[2],i[3],this.projectionMatrix);var o=Math.max(p.lerp(Math.min(t,1e4),1e4,this.elevation/1e7),1),s=Math.max(p.lerp(1e6,Math.max(e,1e6),this.elevation/1e7),1e6);return l.perspective(this.getFieldOfView(),o,s,i[2],i[3],this.projectionMatrix)}}),_}),t(["x_ite/Components","x_ite/Components/Geospatial/GeoCoordinate","x_ite/Components/Geospatial/GeoElevationGrid","x_ite/Components/Geospatial/GeoLOD","x_ite/Components/Geospatial/GeoLocation","x_ite/Components/Geospatial/GeoMetadata","x_ite/Components/Geospatial/GeoOrigin","x_ite/Components/Geospatial/GeoPositionInterpolator","x_ite/Components/Geospatial/GeoProximitySensor","x_ite/Components/Geospatial/GeoTouchSensor","x_ite/Components/Geospatial/GeoTransform","x_ite/Components/Geospatial/GeoViewpoint","x_ite/Components/Geospatial/X3DGeospatialObject"],function(t,e,i,n,o,s,r,a,l,h,d,c,u){"use strict";t.addComponent({name:"Geospatial",types:{GeoCoordinate:e,GeoElevationGrid:i,GeoLOD:n,GeoLocation:o,GeoMetadata:s,GeoOrigin:r,GeoPositionInterpolator:a,GeoProximitySensor:l,GeoTouchSensor:h,GeoTransform:d,GeoViewpoint:c},abstractTypes:{X3DGeospatialObject:u}})})}();
